/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_test.c,v 1.23 2005/06/29 00:23:16 eugene Exp $";

#include <pthread.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"
 
mx_return_t
mx_test(mx_endpoint_t endpoint,
	mx_request_t *handle,
	mx_status_t *status,
	uint32_t *result)
{
    struct mx_endpoint *pp;
    struct mx_post *post;
    
    pthread_mutex_lock(&Mx_po_lock);
    pp = (struct mx_endpoint *)endpoint;

    post = &handle[0]->post;

    if (post->complete){
      *result = 1;
      goto handle_completed;
    } else {
      pthread_mutex_unlock(&Mx_po_lock);
      *result = 0;
      return MX_SUCCESS;
    }
    
 handle_completed:
    /*
     * got a completed post!  Call the post's callback and return the handle
     * of the completed post.
     */
    
    /* pull the post off the list */
    MX_LIST_REMOVE(post);
    
    /* return status*/
    if (status != NULL) {
      *status = post->status;
    }
    
    /* destroy this handle */
    mx_destroy_post(post);
    
    pthread_mutex_unlock(&Mx_po_lock);
    
    return MX_SUCCESS;
}
